/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.Utils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

public class Message {
    private char type;
    private char status;
    private String messageId;
    private Timestamp requested;
    private Timestamp responded = null;
    private BigInteger length = BigInteger.ZERO;
    private String route;
    private byte[] payload;

    public Message(String route, byte[] payload) {
        this.type = (char)48;
        this.status = (char)48;
        this.messageId = UUID.randomUUID().toString();
        this.requested = Timestamp.from(Instant.now());
        this.route = route != null ? route : "";
        this.setPayload(payload);
    }

    public char getType() {
        return this.type;
    }

    public char getStatus() {
        return this.status;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Timestamp getRequested() {
        return this.requested;
    }

    public Timestamp getResponded() {
        return this.responded;
    }

    public BigInteger getLength() {
        return this.length;
    }

    public String getRoute() {
        return this.route;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadString() {
        return new String(this.payload, StandardCharsets.UTF_8);
    }

    public void setError(byte[] payload) {
        this.type = (char)49;
        this.status = (char)49;
        this.responded = Timestamp.from(Instant.now());
        this.setPayload(payload);
    }

    public void setResponse(byte[] payload) {
        this.type = (char)49;
        this.status = (char)48;
        this.responded = Timestamp.from(Instant.now());
        this.setPayload(payload);
    }

    public void setPayload(byte[] payload) {
        this.payload = payload != null ? payload : new byte[]{};
        this.length = BigInteger.valueOf(this.payload.length);
    }

    public void setPayload(String payload) {
        this.setPayload(payload.getBytes(StandardCharsets.UTF_8));
    }

    public String getHeader() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.type);
        sb.append(this.status);
        sb.append(this.messageId);
        sb.append(Utils.timestampToString(this.requested));
        sb.append(Utils.timestampToString(this.responded));
        sb.append(Utils.bigIntegerToFixedString(this.length));
        sb.append(this.route);
        return sb.toString();
    }

    static Message fromHeader(String headerString) {
        Message message = new Message("", new byte[0]);
        message.type = headerString.charAt(0);
        message.status = headerString.charAt(1);
        message.messageId = headerString.substring(2, 38);
        message.requested = Utils.stringToTimestamp(headerString.substring(38, 61));
        message.responded = Utils.stringToTimestamp(headerString.substring(61, 84));
        message.length = Utils.fixedStringToBigInteger(headerString.substring(84, 100));
        message.route = headerString.substring(100);
        return message;
    }
}

