/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StreamFrame {
    public final String streamId;
    public final long seq;
    public final long tsNanos;
    public final boolean key;
    public final byte[] payload;

    public StreamFrame(String streamId, long seq, long tsNanos, boolean key, byte[] payload) {
        this.streamId = streamId;
        this.seq = seq;
        this.tsNanos = tsNanos;
        this.key = key;
        this.payload = payload != null ? payload : new byte[]{};
    }

    public static byte[] encode(StreamFrame f) {
        byte flags = (byte)(f.key ? 1 : 0);
        byte[] buf = new byte[17 + f.payload.length];
        buf[0] = flags;
        ByteBuffer.wrap(buf, 1, 16).putLong(f.seq).putLong(f.tsNanos);
        System.arraycopy(f.payload, 0, buf, 17, f.payload.length);
        return buf;
    }

    public static StreamFrame decode(String streamId, byte[] buf) {
        if (buf == null || buf.length < 17) {
            throw new IllegalArgumentException("Invalid stream frame payload");
        }
        byte flags = buf[0];
        long seq = ByteBuffer.wrap(buf, 1, 8).getLong();
        long ts = ByteBuffer.wrap(buf, 9, 8).getLong();
        byte[] pl = Arrays.copyOfRange(buf, 17, buf.length);
        return new StreamFrame(streamId, seq, ts, (flags & 1) == 1, pl);
    }
}

