/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public final class InboundDemux {
    private final ConcurrentHashMap<UUID, BlockingQueue<byte[]>> qs = new ConcurrentHashMap();
    private final int capacity;

    public InboundDemux(int capacity) {
        this.capacity = Math.max(1, capacity);
    }

    public InboundDemux() {
        this(12);
    }

    public BlockingQueue<byte[]> getQueue(UUID id) {
        return this.qs.computeIfAbsent(id, k -> new LinkedBlockingQueue(this.capacity));
    }

    public void accept(UUID id, byte[] frame) {
        BlockingQueue<byte[]> q = this.getQueue(id);
        if (!q.offer(frame)) {
            q.poll();
            q.offer(frame);
        }
    }

    public void clear(UUID id) {
        BlockingQueue<byte[]> q = this.qs.get(id);
        if (q != null) {
            q.clear();
        }
    }

    public void close(UUID id) {
        BlockingQueue<byte[]> q = this.qs.remove(id);
        if (q != null) {
            q.clear();
        }
    }
}

